/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.file;

import com.quantumdata.fmteditor.Instrument;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.fmteditor.file.LoaderSaver;
import com.quantumdata.fmteditor.srcmenu.SourceMenu;
import com.quantumdata.fmteditor.srcmenu.SourceMenuFrame;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SourceMenuLoader
extends LoaderSaver {
    private SourceMenu m_menu;
    private boolean m_useAfterSave = false;

    public void useAfterSave() {
        this.m_useAfterSave = true;
    }

    protected void localLoad() {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.m_file));
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            if (object instanceof SourceMenu) {
                this.m_menu = (SourceMenu)object;
                this.m_menu.setFileName(this.m_file.getAbsolutePath(), true);
                this.m_frame = new SourceMenuFrame(this.m_menu);
                this.m_success = true;
            } else {
                this.m_errMsg = "Invalid file type";
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_errMsg = fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            this.m_errMsg = iOException.getMessage();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.m_errMsg = "Invalid file type";
        }
        this.callLoadComplete();
    }

    protected void localSave() {
        try {
            SourceMenuFrame sourceMenuFrame = (SourceMenuFrame)this.m_frame;
            String string = this.m_file.getAbsolutePath();
            if (!string.toLowerCase().endsWith(FmtFileType.MENU.extension())) {
                string = string + FmtFileType.MENU.extension();
                this.m_file = new File(string);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.m_file)));
            sourceMenuFrame.captureData();
            objectOutputStream.writeObject(sourceMenuFrame.getData());
            objectOutputStream.close();
            sourceMenuFrame.markUnmodified();
            sourceMenuFrame.getData().setFileName(this.m_file.getAbsolutePath(), true);
            this.m_success = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_errMsg = fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            this.m_errMsg = iOException.getMessage();
        }
        this.callSaveComplete();
    }

    protected void remoteLoad() {
        RemoteInstrument remoteInstrument = this.m_isrc.getInstrument();
        this.m_menu = new SourceMenu();
        try {
            String[] stringArray;
            String string;
            remoteInstrument.tryCommand("DIRL " + this.m_fileName);
            String string2 = remoteInstrument.tryQuery("DIRT?");
            if (Instrument.is882L(remoteInstrument)) {
                if (!string2.equalsIgnoreCase("fmt")) {
                    this.m_errMsg = "Invalid DIRT Type: " + string2;
                    this.callLoadComplete();
                    return;
                }
            } else {
                if (string2.equalsIgnoreCase("sourcelib")) {
                    string = remoteInstrument.tryQuery("NAMQ? 1 1").trim();
                    if (string.length() == 0) {
                        this.m_success = true;
                        this.callLoadComplete();
                        return;
                    }
                    remoteInstrument.tryCommand("DIRL " + string);
                    string2 = remoteInstrument.tryQuery("DIRT?");
                    if (!string2.equalsIgnoreCase("source")) {
                        this.m_errMsg = "\"" + string + "\" has an invalid DIRT: " + string2;
                        this.callLoadComplete();
                        return;
                    }
                }
                this.checkName();
            }
            string = remoteInstrument.tryQuery("NAMQ? 1 9999", 120000);
            for (String string3 : stringArray = string.split("\r\n")) {
                if ((string3 = string3.trim()).length() <= 0) continue;
                this.m_menu.addName(string3);
            }
            this.m_fileName = this.swapExtension(this.m_fileName, ".xml", FmtFileType.MENU.extension());
            this.m_menu.setFileName(this.m_fileName, false);
            this.m_menu.setFromIP(remoteInstrument.getConnection().getName());
            this.m_success = true;
            this.m_frame = new SourceMenuFrame(this.m_menu);
        }
        catch (InstrumentException instrumentException) {
            this.m_errMsg = instrumentException.getMessage();
        }
        this.callLoadComplete();
    }

    protected void remoteSave() {
        RemoteInstrument remoteInstrument = this.m_isrc.getInstrument();
        try {
            String string;
            SourceMenuFrame sourceMenuFrame = (SourceMenuFrame)this.m_frame;
            sourceMenuFrame.captureData();
            this.m_menu = sourceMenuFrame.getData();
            this.m_fileName = this.swapExtension(this.m_fileName, FmtFileType.MENU.extension(), ".xml");
            if (Instrument.is882L(remoteInstrument)) {
                remoteInstrument.tryCommand("DIRN;DIRB;DIRT FMT");
                string = this.m_fileName;
            } else {
                this.checkName();
                string = this.getTmpName();
                remoteInstrument.tryCommand("DIRN;DIRB;DIRT SOURCELIB");
                remoteInstrument.tryCommand("NAMI 1 " + string);
                remoteInstrument.tryCommand("DIRE;DIRA " + this.m_fileName);
                remoteInstrument.tryCommand("DIRN;DIRB;DIRT SOURCE");
            }
            int n = this.m_menu.getNameCount();
            for (int i = 0; i < n; ++i) {
                remoteInstrument.tryCommand("NAMI " + (i + 1) + " " + this.m_menu.getName(i));
            }
            remoteInstrument.tryCommand("DIRE;DIRA " + string);
            if (this.m_useAfterSave) {
                remoteInstrument.tryCommand("DIRL " + this.m_fileName + ";DIRU");
            }
            this.m_fileName = this.swapExtension(this.m_fileName, ".xml", FmtFileType.MENU.extension());
            this.m_menu.setFileName(this.m_fileName, false);
            this.m_menu.setFromIP(remoteInstrument.getConnection().getName());
            this.m_success = true;
        }
        catch (InstrumentException instrumentException) {
            this.m_errMsg = instrumentException.getMessage();
        }
        this.callSaveComplete();
    }

    private void checkName() {
        String string = this.m_file.getName();
        if (string.toLowerCase().startsWith("tmp_")) {
            String string2;
            if ((string = string.substring("tmp_".length())).length() == 0) {
                string = "noname";
            }
            this.m_fileName = (string2 = this.m_file.getParent()) != null ? string2 + File.separatorChar + string : string;
            this.m_fileName = this.m_fileName.replace('\\', '/');
            this.m_menu.setFileName(this.m_fileName, false);
            this.m_file = new File(this.m_fileName);
        }
    }

    private String getTmpName() {
        String string = this.m_file.getParent();
        String string2 = string != null ? string + File.separatorChar + "tmp_" + this.m_file.getName() : "tmp_" + this.m_file.getName();
        string2 = string2.replace('\\', '/');
        return string2;
    }
}

